set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Figure 4

**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	
	*Calculate log change in value added share of industries
	bysort country year: egen totVA=sum(VA)
	gen lnVAtot=ln(totVA)
	tsset cross year
	gen D1_lnVAtot=D1.lnVAtot*100
	gen D1_lnVAshare=D1_lnVA-D1_lnVAtot
	
	collapse (mean) D1_lnlaborshare D1_lnH_EMP D1_lnVAshare D1_LP1_EMP weight*, by(sector_short code sectorgroup) /*mean across country-years*/
	
**2. Make Figure 4

	*Regression equivalent
	reg D1_lnVAshare D1_LP1_EMP [w=weight_VA]
	eststo col1
	esttab col1,  b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 
	
	gen pos=12
	gen slabel=sector_short if code=="29"|code=="20"|code=="71t74"|code=="J"|code=="N"|code=="64"|code=="30t33"|code=="17t19"|code=="H"|code=="70"|code=="C"|code=="15t16"|code=="26"|code=="24"|code=="23"|code=="M"|code=="F"|code=="27t28"|code=="51"
	replace pos=3 if code=="51" | code=="20"
	replace pos=4 if code=="27t28"
	replace pos=6 if code=="26" | code=="23"
	replace pos=9 if code=="H" | code=="52" | code=="O"
	replace slabel="Retail" if code=="52"
	replace slabel="Wholesale" if code=="51"
	replace slabel="Other prsnl svcs" if code=="O"
	replace slabel="Metals" if code=="27t28"

	twoway 	(scatter D1_lnVAshare D1_LP1_EMP if sectorgroup==1, msymbol(Oh) mcolor(navy) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnVAshare D1_LP1_EMP if sectorgroup==2, msymbol(d)  mcolor(maroon) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnVAshare D1_LP1_EMP if sectorgroup==3, msymbol(T)  mcolor(forest_green) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnVAshare D1_LP1_EMP if sectorgroup==4, msymbol(+)  mcolor(dkorange) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnVAshare D1_LP1_EMP if sectorgroup==5, msymbol(O)  mcolor(teal) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8) ///
			 xlabel(-2.5(.5)5) ///
			legend(order(1 "Mining, util's & construction" 2 "Manufacturing" 3 "Education & health" 4 "Low-tech svcs" 5 "High-tech svcs" 6 "Weighted linear fit")) legend(rows(2)) legend(span) ///
			bgcolor(white) plotregion(color(white)) graphregion(color(white)) ///	
			ytitle("Average annual change in log" "value-added share (log points)") xtitle("Average annual TFP growth (log points)") ///
			note("Unweighted average across country-years; linear fit is weighted by industries' value-added shares," "slope coefficient is -0.606 (standard error 0.158), R2=0.361.", span)) ///
			(lfit D1_lnVAshare D1_LP1_EMP [w=weight_VA], lcolor(black))
								
	graph export "$path_out\Fig4.eps", as(eps) replace					
